﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<script runat="server" type="text/C#">
    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息，
    bool isLoadPage = true;  //定义页面是否加载

    private string action = string.Empty;
    private int Id = 0;

    public static int MaxSendNum = 0;
    public static int MaxTitleLen = 0;
    public static int MaxMsgLen = 0;


    protected void Page_Load(object sender, EventArgs e)
    {
        action = KSCMS.S("action");
        if (string.IsNullOrEmpty(action))
        {
            action = KSCMS.S("do");
        }
        Id = Utils.StrToInt(BasicField.GetParam("id"));

        MaxSendNum = Utils.StrToInt(UserGroupManage.GetGroupSettings(2));
        MaxTitleLen = Utils.StrToInt(UserGroupManage.GetGroupSettings(3));
        MaxMsgLen = Utils.StrToInt(UserGroupManage.GetGroupSettings(4));

        action = action.ToLower();
        if (action.Equals("dosave"))
        {
            isLoadPage = false;
            DoSave();
            return;
        }
    }
    private void DoSave()
    {
        #region 保存发送
        string ToUserName = Utils.RemoveXss(KSCMS.S("ToUserName"));
        // Boolean SendToMore = false;
        if (ToUserName.LastIndexOf(",") < 0)
        {
            // SendToMore = false;
            if (ToUserName == (new TemporaryVar()).UserName)
            {
                Msg.Alert("对不起，不能发给自己!");
                return;
            }
        }
        else
        {
            //SendToMore = true;
        }
        string subject = Utils.RemoveXss(KSCMS.S("Subject"));
        string mailcontent = Utils.RemoveXss(KSCMS.S("MsgContent"));
        if (MaxTitleLen != 0 && subject.Length > MaxTitleLen)
        {
            Msg.Alert("短消息标题最多只能 " + MaxTitleLen + " 个字符!");
            return;

        }
        if (MaxMsgLen != 0 && Utils.RemoveHtml(mailcontent).Length > MaxMsgLen)
        {
            Msg.Alert("短消息内最多只能 " + MaxMsgLen + " 个字符!");
            return;
        }

        int errNum = 0;
        int succNum = 0;
        string[] ToUserNameArr = Utils.SplitString(ToUserName, ",");
        if (ToUserNameArr.Length > MaxSendNum && MaxSendNum!=0)
        {
            Msg.Alert("一次只能同时发给 " + MaxSendNum + " 个用户!");
            return;
        }
        else
        {
            foreach (string UserName in ToUserNameArr)
            {
                if (DataFactoryUser.Exists("KS_User", "username='" + UserName.Trim() + "'"))
                {
                    succNum++;
                    sendMail(UserName.Trim(),subject,mailcontent);
                }
                else
                {
                    errNum++;
                }
            }

            if (errNum > 0)
            {
                if (succNum == 0)
                {
                    Msg.Alert("发送完毕!成功" + succNum + "条,失败" + errNum + "条!");
                }
                else
                {
                    Msg.Alert("发送完毕!成功" + succNum + "条,失败" + errNum + "条!", BasicField.GetUserUrl("message/sendmessage"));
                }

            }
            else
            {
                Msg.Alert("恭喜,短消息发送成功!", BasicField.GetUserUrl("message/sendmessage"));

            }
        }
        #endregion
    }
    private void sendMail(string ToUserName,string subject,string mailcontent)
    {
        Hashtable ht = new Hashtable();
        ht.Add("SubjectID", 0);
        ht.Add("ToUserName", ToUserName);
        ht.Add("FromUserName",__user.UserName);
        ht.Add("MsgTitle", subject);
        ht.Add("MsgContactMan", "");
        ht.Add("MsgTel", "");
        ht.Add("MsgMail", "");
        ht.Add("MsgContent", mailcontent);
        ht.Add("RequestInfo", "");
        ht.Add("AddDate", DateTime.Now);
        ht.Add("ReadTF", 0);
        ht.Add("DelTF", 0);
        ht.Add("Verify", 1);
        CommonData.Insert("KS_Message", ht);
        Kesion.Cache.CommonJsonCache.CleanMessageNum(ToUserName);    //更新用户新消息数缓存
    }


</script>

<%
    if (!isLoadPage) return;
%>

<div class="r_tybox t_tybox nomar">
  <div class="r_title tytitle pd0">
    <h4 class="ty-none">站内信息</h4>
     <div class="tabs">  
        <ul>
            <%
                  Response.Write(@"<li class=""puton""><a href=""" + BasicField.GetUserUrl("message/Receivedmessage") + @""">站内消息</a></li>");
                  Response.Write(@"<li><a href=""" + BasicField.GetUserUrl("other/mychatinfo") + @""">我的咨询</a></li>");
                  Response.Write(@"<li><a href=""" + BasicField.GetUserUrl("other/comment") + @""">我的评价</a></li>");
                  if (CommonJsonCache.CheckYunAPPHasAllow("plus.ask"))
                  {
                      Response.Write(@"<li><a href=""" + BasicField.GetUserUrl("other/MyAsk") + @""">问题互动</a></li>");
                  }
                  if (BaseFun.CheckModulePower("edu"))
                  {
                      Response.Write(@"<li><a href=""" + BasicField.GetUserUrl("Course/MyCosZan", "optype") + @""">我的点赞</a></li>");
                      Response.Write(@" <li><a href=""" + BasicField.GetUserUrl("Course/MyInteractRecord") + @""">互动礼物</a></li>");
                  }
                 %>
        </ul>
    </div>       
  </div>
   <div class="top-sort clearfix">
        <div class="top-sort-tab">  
            <ul>
                <li><a href="<%=BasicField.GetUserUrl("message/receivedmessage") %>">我收到的消息</a></li>
                <li><a href="<%=BasicField.GetUserUrl("message/sentmessage") %>">我发出的消息</a></li>
                <li><a href="<%=BasicField.GetUserUrl("message/Garbagemessage") %>">垃圾消息</a></li>
                <li class="puton"><a href="<%=BasicField.GetUserUrl("message/Sendmessage") %>">发送短消息</a></li>
            </ul>
        </div>  
    </div> 
    <% Kesion.APPCode.EditorAPI.EchoHead();

        string toUserName = string.Empty;
        string Subject = string.Empty;
        string MsgContent = string.Empty;
        if (Id > 0)
        {
            using(DataTable dt=DataFactory.GetDataTable("select top 1 * From KS_Message Where ID="+Id+" and tousername='" + __user.UserName + "'"))
            {
                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    toUserName = dr["fromusername"].ToString();
                    Subject = "Re:" + dr["MsgTitle"].ToString();
                    MsgContent = "回复：<br/><br/><br/><hr>原内容："+dr["MsgContent"].ToString();
                }
            }
        }

        %>


    <script type="text/javascript">
        CheckForm = function() {
            if ($("#ToUserName").val() == "") {
                $.dialog.alert('收件人必须输入!', function() {
                    $("#ToUserName").focus();
                });
                return false;
            }
            if ($("#Subject").val() == "") {
                $.dialog.alert('消息标题必须输入!', function() {
                    $("#Subject").focus();
                });
                return false;
            }
            if (editor.hasContents() == false) {
                $.dialog.alert('消息内容必须输入！', function() {
                   editor.focus();
                });
                return false;
            }
            return true;
        }
    </script>

   	<iframe src="about:blank" name="hidframe" style="display:none;width:0px;height:0px"></iframe>
    <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidframe">
        <input type="hidden" name="action" value="dosave"/>
        <table width="100%" class="border" align="center" cellspacing="0" cellpadding="0">
            <tr class="tdbg">
                <td class="lefttd" style="width:120px;">收件人：</td>
                <td class="tag_left">
                    <input type="text" name="ToUserName" id="ToUserName" maxlength="220" class="textbox" value="<%=toUserName %>" /><font color=red>*</font> 
                    <span class="tips">多个收件人请用英文逗号隔开。</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="lefttd">标　题：</td>
                <td class="tag_left">
                    <input type="text" name="Subject" id="Subject" maxlength="220" class="textbox" value="<%=Subject %>"/><font color=red>*</font> 
                </td>
            </tr>
            <tr class="tdbg">
                <td class="lefttd">内　容：</td>
                <td class="tag_left">
                	<textarea name="MsgContent" rows="3" cols="3" id="MsgContent" style="width:95%;height:150px"><%=MsgContent %></textarea>
                	<%
                    Kesion.APPCode.EditorAPI.EchoEditor("editor", "MsgContent", "Basic", 0, false, true, true, false);    
                 	%>
    
                </td>
            </tr>
            <tr class="tdbg">
                <td class="lefttd"></td>
                <td height="50" class="tag_left"><input type="submit" ID="BtnSend" class="green-bt green-bt-big button" value="发 送" onclick="return (CheckForm())"  style="margin-left:0"/></td>
            </tr>
        </table>   
        <br />
        <div style="line-height:28px; color:#666;padding:0 20px 20px 20px;font-size:13px;"> 
            <strong>操作小贴士</strong><br />
            <p style="color:#999">
            ① 发布信息,请严格遵守法律法规。对于不按要求发布的用户，我们将锁定账户处理。<br />
            ② 可以用英文状态下的逗号将用户名隔开实现群发，最多<%=MaxSendNum%>个用户<br />
            ③ 标题最多<%=MaxTitleLen%>个字符，内容最多<%=MaxMsgLen %>个字符
            </p>
        </div>
    </form>

</div>